# Helper criado com base no helper da gem twitter-bootstrap-rails
module BootstrapFlashHelper
  ALERT_TYPES = [:success, :info, :warning, :danger] unless const_defined?(:ALERT_TYPES)

  def bootstrap_flash(options = {})
    flash_messages = []
    flash.each do |type, message|
      # Skip empty messages, e.g. for devise messages set to nothing in a locale file.
      next if message.blank?

      type = type.to_sym
      type = :success if type == :notice
      type = :danger if type == :alert
      type = :danger if type == :error
      type = :info if t('devise.failure.unauthenticated') == message

      next unless ALERT_TYPES.include?(type)

      icon = if type == :info
               'fa-info'
             elsif type == :danger
               'fa-times'
             elsif type == :warning
               'fa-warning'
             else
               'fa-check'
             end

      Array(message).each do |msg|
        text = content_tag(
          :div,
          content_tag(:button, raw('&times;'), class: 'close', 'data-dismiss' => 'alert') +
          raw("<i class='fa-fw fa #{icon}'></i> #{msg}"), class: "alert fade in alert-#{type} #{options[:class]}"
        )

        flash_messages << text if msg
      end
    end

    flash_messages.join("\n").html_safe
  end
end
